<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SessionInvestmentFunds
 *
 * @ORM\Table(name="investment_funds_sessions")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\SessionInvestmentFundsRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class SessionInvestmentFunds
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="investmentFundsId", type="integer")
     */
    private $investmentFundsId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date", type="datetime")
     */
    private $date;

    /**
     * @var float
     *
     * @ORM\Column(name="open", type="float")
     */
    private $open;

    /**
     * @var float
     *
     * @ORM\Column(name="high", type="float")
     */
    private $high;

    /**
     * @var float
     *
     * @ORM\Column(name="low", type="float")
     */
    private $low;

    /**
     * @var float
     *
     * @ORM\Column(name="close", type="float")
     */
    private $close;

    /**
     * @var float
     *
     * @ORM\Column(name="volume", type="float")
     */
    private $volume;

    /**
     * @var float
     *
     * @ORM\Column(name="oi", type="float")
     */
    private $oi;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createAt", type="datetime")
     */
    private $createAt;

    /**
     * @ORM\ManyToOne(targetEntity="InvestmentFunds",inversedBy="sessions")
     * @ORM\JoinColumn(name="investmentFundsId", referencedColumnName="id")
     */
    private $investmentFunds;

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createAt = new \DateTime();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set investmentFundsId
     *
     * @param integer $investmentFundsId
     * @return SessionInvestmentFunds
     */
    public function setInvestmentFundsId($investmentFundsId)
    {
        $this->investmentFundsId = $investmentFundsId;
    
        return $this;
    }

    /**
     * Get investmentFundsId
     *
     * @return integer 
     */
    public function getInvestmentFundsId()
    {
        return $this->investmentFundsId;
    }

    /**
     * Set date
     *
     * @param \DateTime $date
     * @return SessionInvestmentFunds
     */
    public function setDate($date)
    {
        $this->date = $date;
    
        return $this;
    }

    /**
     * Get date
     *
     * @return \DateTime 
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * Set open
     *
     * @param float $open
     * @return SessionInvestmentFunds
     */
    public function setOpen($open)
    {
        $this->open = $open;
    
        return $this;
    }

    /**
     * Get open
     *
     * @return float 
     */
    public function getOpen()
    {
        return $this->open;
    }

    /**
     * Set high
     *
     * @param float $high
     * @return SessionInvestmentFunds
     */
    public function setHigh($high)
    {
        $this->high = $high;
    
        return $this;
    }

    /**
     * Get high
     *
     * @return float 
     */
    public function getHigh()
    {
        return $this->high;
    }

    /**
     * Set low
     *
     * @param float $low
     * @return SessionInvestmentFunds
     */
    public function setLow($low)
    {
        $this->low = $low;
    
        return $this;
    }

    /**
     * Get low
     *
     * @return float 
     */
    public function getLow()
    {
        return $this->low;
    }

    /**
     * Set close
     *
     * @param float $close
     * @return SessionInvestmentFunds
     */
    public function setClose($close)
    {
        $this->close = $close;
    
        return $this;
    }

    /**
     * Get close
     *
     * @return float 
     */
    public function getClose()
    {
        return $this->close;
    }

    /**
     * Set volume
     *
     * @param float $volume
     * @return SessionInvestmentFunds
     */
    public function setVolume($volume)
    {
        $this->volume = $volume;
    
        return $this;
    }

    /**
     * Get volume
     *
     * @return float 
     */
    public function getVolume()
    {
        return $this->volume;
    }

    /**
     * Set oi
     *
     * @param float $oi
     * @return SessionInvestmentFunds
     */
    public function setOi($oi)
    {
        $this->oi = $oi;
    
        return $this;
    }

    /**
     * Get oi
     *
     * @return float 
     */
    public function getOi()
    {
        return $this->oi;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return SessionInvestmentFunds
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }

    /**
     * Set investmentFunds
     *
     * @param \Import\ApiBundle\Entity\InvestmentFunds $investmentFunds
     * @return SessionInvestmentFunds
     */
    public function setInvestmentFunds(\Import\ApiBundle\Entity\InvestmentFunds $investmentFunds = null)
    {
        $this->investmentFunds = $investmentFunds;
    
        return $this;
    }

    /**
     * Get investmentFunds
     *
     * @return \Import\ApiBundle\Entity\InvestmentFunds 
     */
    public function getInvestmentFunds()
    {
        return $this->investmentFunds;
    }
}